% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size_of_repetitions.R
\name{size_of_repetitions}
\alias{size_of_repetitions}
\alias{size_of_repetitions.eventlog}
\alias{size_of_repetitions.grouped_eventlog}
\alias{size_of_repetitions.activitylog}
\alias{size_of_repetitions.grouped_activitylog}
\title{Metric: Size of repetitions}
\usage{
size_of_repetitions(
  log,
  type = c("all", "repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity")
)

\method{size_of_repetitions}{eventlog}(
  log,
  type = c("all", "repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity")
)

\method{size_of_repetitions}{grouped_eventlog}(
  log,
  type = c("repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity")
)

\method{size_of_repetitions}{activitylog}(
  log,
  type = c("repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity")
)

\method{size_of_repetitions}{grouped_activitylog}(
  log,
  type = c("repeat", "redo"),
  level = c("log", "case", "activity", "resource", "resource-activity")
)
}
\arguments{
\item{log}{\code{\link[bupaR]{log}}: Object of class \code{\link[bupaR]{log}} or derivatives (\code{\link[bupaR]{grouped_log}}, \code{\link[bupaR]{eventlog}}, \code{\link[bupaR]{activitylog}}, etc.).}

\item{type}{\code{\link{character}} (default \code{"all"}): The type of repetitions: \code{"all"} (default),
\code{"repeat"}, or \code{"redo"}. For more information, see 'Details' below.}

\item{level}{\code{\link{character}} (default \code{"log"}): Level of granularity for the analysis: \code{"log"} (default),
\code{"case"}, \code{"activity"}, \code{"resource"}, or \code{"resource-activity"}. For more information,
see \code{vignette("metrics", "edeaR")} and 'Details' below.}
}
\description{
Provides summary statistics on the sizes of repetitions.
}
\section{Methods (by class)}{
\itemize{
\item \code{size_of_repetitions(eventlog)}: Size of repetitions for eventlog

\item \code{size_of_repetitions(grouped_eventlog)}: Size of repetitions for grouped event log

\item \code{size_of_repetitions(activitylog)}: Size of repetitions for activitylog

\item \code{size_of_repetitions(grouped_activitylog)}: Size of repetitions for grouped activitylog

}}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
\seealso{
\code{\link{number_of_repetitions}}
}
\concept{metrics_repetition}
