% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{weather}
\alias{weather}
\title{Daily Weather Data for Top Stations (2014–2024)}
\format{
A tibble with 35,527 rows and 18 variables:
\describe{
  \item{ws_id}{Weather station ID (e.g., "948720-99999")}
  \item{stn_lat}{Latitude of the weather station}
  \item{stn_lon}{Longitude of the weather station}
  \item{date}{Observation date (YYYY-MM-DD)}
  \item{year}{Year of observation}
  \item{month}{Month of observation (1–12)}
  \item{day}{Day of the month}
  \item{weekday}{Day of the week (as ordered factor)}
  \item{dayofyear}{Day of the year (1–366)}
  \item{temp}{Average temperature (°C)}
  \item{min}{Minimum temperature (°C)}
  \item{max}{Maximum temperature (°C)}
  \item{dewp}{Dew point temperature (°C)}
  \item{rh}{Relative humidity (\%)}
  \item{prcp}{Precipitation (mm)}
  \item{rainy}{Binary flag indicating whether PRCP > 5 mm (1 = rainy day)}
  \item{wind_speed}{Average wind speed (m/s)}
  \item{max_speed}{Maximum sustained wind speed (m/s)}
}
}
\source{
GSOD via \pkg{GSODR}
}
\usage{
weather
}
\description{
This dataset contains daily weather observations for the top weather stations
associated with focal species in the ecotourism package. Data spans from 2014
to 2024 and includes temperature, humidity, precipitation, and wind measures.
}
\details{
The weather data was retrieved from the Global Surface Summary of the Day (GSOD)
dataset via the \pkg{GSODR} package for the top 3 weather stations per organism
in the ecotourism project. This data supports climate-biodiversity interaction analyses.
}
\examples{
data(weather)
head(weather)
}
\seealso{
\code{\link{top_stations}}, \code{\link{glowworms}}, \code{\link{gouldian_finch}}, \code{\link{weather_stations}}
}
\keyword{datasets}
