% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abm3pc_sys.R
\name{abm3pc_sys}
\alias{abm3pc_sys}
\title{Adams-Bashford-Moulton for system of equations}
\usage{
abm3pc_sys(f, a, b, y0, n, Pars, ...)
}
\arguments{
\item{f}{function in the differential equation \eqn{y' = f(x, y)};
defined as a function \eqn{R \times R^m \rightarrow R^m}, where \eqn{m} is the number of equations.}

\item{a}{starting time for the interval to integrate}

\item{b}{ending time for the interval to integrate.}

\item{y0}{starting values at time \code{a}}

\item{n}{number of steps}

\item{Pars}{named list of parameters passed to f}

\item{...}{additional inputs to function \code{f}}
}
\value{
List with components x for grid points between a and b and y an
n-by-m matrix with solutions for variables in columns, i.e.
each row contains one time stamp.
}
\description{
Third-order Adams-Bashford-Moulton predictor-corrector method.
}
\details{
Combined Adams-Bashford and Adams-Moulton (or: multi-step) method of third order
with corrections according to the predictor-corrector approach.
Copied from pracma under GPL-3, with small modifications to work with RTMB
}
