% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.R
\name{manip_factor_2_numeric}
\alias{manip_factor_2_numeric}
\title{converts factor to numeric preserving numeric levels and order in
  character levels.}
\usage{
manip_factor_2_numeric(vec)
}
\arguments{
\item{vec}{vector}
}
\value{
vector
}
\description{
before converting we check whether the levels contain a number,
  if they do the number will be preserved.
}
\examples{
fac_num = factor( c(1,3,8) )
fac_chr = factor( c('foo','bar') )
fac_chr_ordered = factor( c('a','b','c'), ordered = TRUE )

manip_factor_2_numeric( fac_num )
manip_factor_2_numeric( fac_chr )
manip_factor_2_numeric( fac_chr_ordered )
# does not work for decimal numbers
manip_factor_2_numeric(factor(c("A12", "B55", "10e4")))
manip_factor_2_numeric(factor(c("1.56", "4.56", "8.4")))
}
\seealso{
\code{\link[stringr]{str_detect}}
}
