% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_custom_grep}
\alias{EPM_custom_grep}
\title{Custom XML Tag Matching.}
\usage{
EPM_custom_grep(xml_data, tag, xclass = NULL, format = "list")
}
\arguments{
\item{xml_data}{String (character vector of length 1), this is a string
including PubMed records or string including XML/HTML tags.}

\item{tag}{String (character vector of length 1), the tag of 
interest (e.g., "Title") (should NOT include < > chars).}

\item{xclass}{String (character vector of length 1), a tag decorator 
of interest (e.g., "EIdType=\"doi\""). Can be NULL.}

\item{format}{String. Must be a value in c("list", "char"). Indicates the 
type of output. Defaults to "list".}
}
\value{
List or vector where each element corresponds to an in-tag substring.
}
\description{
Extract text form a string containing XML or HTML tags. 
Text included between tags of interest will be returned. 
If multiple tagged substrings are found, they will be returned as different 
elements of a list or character vector.
}
\examples{
x <- "This string includes <Ti>an XML Tag</Ti>."
easyPubMed:::EPM_custom_grep(x, tag = "Ti")

}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
