% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_check_guide}
\alias{EPM_check_guide}
\title{Check Metadata from Imported XML Files.}
\usage{
EPM_check_guide(x)
}
\arguments{
\item{x}{Data.frame including information from the imported XML files. The
following columnnames are expected: `index`, `file`, `JobUniqueId`, 
`JobQuery`, `JobBatch`.}
}
\value{
Data.frame identical to `x` with an additional *numeric) column 
(`pass` column).
}
\description{
Analyze the Metadata from different XML files that were imported using
easyPubMed and identify which records / files can be merged together and
which ones to exclude. Only files with the same unique ID can be merged 
together a this step. The goal is to re-build a consistent easyPubMed
object.
}
\examples{
gx <- data.frame(
  index = c(1, 2, 3, 4, 5),
  JobUniqueId = rep('xyz0x', 5),
  JobQuery = rep('test_query', 1),
  JobBatch = c(1, 2, 3, 4, 3),
  JobBatchNum = rep(4, 5),
  stringsAsFactors = FALSE)
easyPubMed:::EPM_check_guide(gx)



}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
