% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinSeg.R
\docType{methods}
\name{BinSeg}
\alias{BinSeg}
\alias{BinSeg-class}
\alias{BinSeg-methods}
\alias{BinSeg,ANY-method}
\title{An S4 method to detect the change-points in an irregularly spaced time series using Binary Segmentation.}
\usage{
BinSeg(
  H,
  thresh = "universal",
  q = 0.99,
  p = 1,
  z = NULL,
  start.values = c(0.9, 0.6),
  dampen.factor = "auto",
  epsilon = 1e-05,
  LOG = TRUE,
  process = "acd",
  acd_p = 0,
  acd_q = 1,
  do.parallel = 2
)

\S4method{BinSeg}{ANY}(
  H,
  thresh = "universal",
  q = 0.99,
  p = 1,
  z = NULL,
  start.values = c(0.9, 0.6),
  dampen.factor = "auto",
  epsilon = 1e-05,
  LOG = TRUE,
  process = "acd",
  acd_p = 0,
  acd_q = 1,
  do.parallel = 2
)
}
\arguments{
\item{H}{The input irregular time series.}

\item{thresh}{The threshold parameter which acts as a stopping rule to detect further change-points and has the form C log(sample). If "universal" then C is data-independent and preselected using the approach described in Korkas (2022). If "boot" it uses the data-dependent method \code{boot_thresh}. Default is "universal".}

\item{q}{The universal threshold simulation quantile or the bootstrap distribution quantile. Default is 0.99.}

\item{p}{The support of the CUSUM statistic. Default is 1.}

\item{z}{Transform the time series to use for post-processing. If NULL this is done automatically. Default is NULL.}

\item{start.values}{Warm starts for the optimizers of the likelihood functions.}

\item{dampen.factor}{The dampen factor in the denominator of the residual process. Default is "auto".}

\item{epsilon}{A parameter added to ensure the boundness of the residual process. Default is  1e-5.}

\item{LOG}{Take the log of the residual process. Default is TRUE.}

\item{process}{Choose between acd or hawkes. Default is acd.}

\item{acd_p}{The p order of the ACD model. Default is 0.}

\item{acd_q}{The q order of the ACD model. Default is 1.}

\item{do.parallel}{Choose the number of cores for parallel computation. If 0 no parallelism is done. Default is 2. (Only applies if thresh = "boot").}
}
\value{
Returns a list with the detected change-points and the transformed series.
}
\description{
An S4 method to detect the change-points in an irregularly spaced time series using the Binary Segmentation methodology described in Korkas (2022).
}
\examples{
pw.acd.obj <- new("simACD")
pw.acd.obj@cp.loc <- seq(0.1,0.95,by=0.025)
pw.acd.obj@lambda_0 <- rep(c(0.5,2),1+length(pw.acd.obj@cp.loc)/2)
pw.acd.obj@alpha <- rep(0.2,1+length(pw.acd.obj@cp.loc))
pw.acd.obj@beta <- rep(0.4,1+length(pw.acd.obj@cp.loc))
pw.acd.obj@N <- 5000
pw.acd.obj <- pc_acdsim(pw.acd.obj)
ts.plot(pw.acd.obj@x,main="Standard BS");abline(v=BinSeg(pw.acd.obj@x)[[1]],col="blue")
#real change-points in grey
abline(v=floor(pw.acd.obj@cp.loc*pw.acd.obj@N),col="grey",lty=2)
}
\references{
Korkas, K.K., 2022. Ensemble binary segmentation for irregularly spaced data with change-points. Journal of the Korean Statistical Society, 51(1), pp.65-86.
}
