% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmfcm.R
\name{pmfcm}
\alias{pmfcm}
\title{CDF of the exponential Factor Copula Model (vector input)}
\usage{
pmfcm(
  w,
  lambda,
  delta,
  dist = NULL,
  coord = NULL,
  smooth = 0.5,
  abseps = 1e-05,
  releps = 1e-05,
  maxpts = 25000,
  miles = FALSE
)
}
\arguments{
\item{w}{Numeric vector of length \eqn{d}.}

\item{lambda, delta}{Positive scalars: common-factor rate \eqn{\lambda} and range \eqn{\delta}.}

\item{dist}{Optional \eqn{d\times d} distance matrix. If \code{NULL}, provide \code{coord}.}

\item{coord}{Optional two-column matrix/data.frame of coordinates (lon, lat) to build \code{dist}.}

\item{smooth}{Matérn smoothness \eqn{\nu} (default \code{0.5}).}

\item{abseps, releps}{Absolute/relative tolerances for the MVN CDF.}

\item{maxpts}{Maximum number of function evaluations for the MVN CDF.}

\item{miles}{Logical; passed to \code{fields::rdist.earth()} if \code{coord} is used.}
}
\value{
A single numeric CDF value in \eqn{[0,1]}.
}
\description{
Computes the eFCM-based \eqn{P(W \leq w)} for a single \eqn{d}-dimensional vector \eqn{w}.
}
\examples{
data(LonLat)
d <- 2
w <- rep(0.3, d)
pmfcm(w, lambda = 2, delta = 100, coord = LonLat[1:2, ])
}
