# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' The Distribution of Univariate Factor Copula Model
#'
#' Density, distribution function, quantile function and random generation
#' for the distribution of univariate factor copula model with rate parameter
#' equal to `lambda`.
#'
#' @param w A numeric value representing the spatial process.
#' @param lambda A numeric value representing rate parameter \eqn{\lambda}.
#' @param u a numeric vector of probabilities, with values in the interval from 0 to 1, at which the quantile function is to be computed.
#' @param tol a scalar indicating the desired level of numerical accuracy for the algorithm; default is 1e-9.
#' @param niter a scalar indicating the maximum number of iterations.
#' @param n an integer value specifying the number of samples to generate
#' @return
#' `dfcm` gives a numeric value representing the density of the factor copula model evaluated at \code{w},
#' `pfcm` gives a numeric value representing the CDF evaluated at \code{w},
#' `qfcm` gives the quantile function (QF) of the factor copula model.
#' and `rfcm` generate a numeric vector of random samples drawn.
#' @details
#' The univariate eFCM distribution is \deqn{F(w;\lambda)=\Phi(w)-exp(\lambda^2/2-\lambda w)\Phi(w-\lambda),}
#' where \eqn{\lambda} is the rate parameter.
#' @export
pfcm <- function(w, lambda) {
    .Call(`_eFCM_pfcm`, w, lambda)
}

#' @examples
#' pfcm(w = 1, lambda = 0.5)
#' dfcm(w = 1, lambda = 0.5)
#' qfcm(u = 0.5, lambda = 0.5)
#' rfcm(n = 1000, lambda = 0.5)
#'
#' @export
#' @rdname pfcm
dfcm <- function(w, lambda) {
    .Call(`_eFCM_dfcm`, w, lambda)
}

#' @export
#' @rdname pfcm
qfcm <- function(u, lambda, tol = 1e-8, niter = 1000L) {
    .Call(`_eFCM_qfcm`, u, lambda, tol, niter)
}

#' @export
#' @rdname pfcm
rfcm <- function(n, lambda) {
    .Call(`_eFCM_rfcm`, n, lambda)
}

ecGeneral <- function(ranks, d, x, n, k, result) {
    .Call(`_eFCM_ecGeneral`, ranks, d, x, n, k, result)
}

mi_condMVN <- function(mean, sigma, given_ind) {
    .Call(`_eFCM_mi_condMVN`, mean, sigma, given_ind)
}

pmvnorm <- function(bound, mean, cormat, abseps = 1e-5, releps = 1e-5, maxpts = 25000L) {
    .Call(`_eFCM_pmvnorm`, bound, mean, cormat, abseps, releps, maxpts)
}

pmfcm_rcpp <- function(w, lambda, delta, dist, smooth = 0.5, abseps = 1e-5, releps = 1e-5, maxpts = 25000L) {
    .Call(`_eFCM_pmfcm_rcpp`, w, lambda, delta, dist, smooth, abseps, releps, maxpts)
}

rmfcm_rcpp <- function(lambda, delta, dist, nu = 0.5, n = 500000L) {
    .Call(`_eFCM_rmfcm_rcpp`, lambda, delta, dist, nu, n)
}

chi_fcm <- function(h, u, lambda, delta, nu = 0.5, abseps = 1e-5, releps = 1e-5, maxpts = 25000L) {
    .Call(`_eFCM_chi_fcm`, h, u, lambda, delta, nu, abseps, releps, maxpts)
}

chiv <- function(u, b, h, nu = 0.5, abseps = 1e-5, releps = 1e-5, maxpts = 25000L) {
    .Call(`_eFCM_chiv`, u, b, h, nu, abseps, releps, maxpts)
}

log_Cn <- function(theta, u_star, dist_mat, nu) {
    .Call(`_eFCM_log_Cn`, theta, u_star, dist_mat, nu)
}

log_fn <- function(zi, lambda, sigma_inv, C_inv) {
    .Call(`_eFCM_log_fn`, zi, lambda, sigma_inv, C_inv)
}

log_f1 <- function(zij, lambda) {
    .Call(`_eFCM_log_f1`, zij, lambda)
}

dF1 <- function(z, theta, islog = FALSE) {
    .Call(`_eFCM_dF1`, z, theta, islog)
}

dFI <- function(z, I, dist_mat, theta, nu, islog = FALSE) {
    .Call(`_eFCM_dFI`, z, I, dist_mat, theta, nu, islog)
}

dCI <- function(u, I, dist_mat, theta, nu, islog = FALSE) {
    .Call(`_eFCM_dCI`, u, I, dist_mat, theta, nu, islog)
}

log_partialCn <- function(theta, data_u, u_star, dist_mat, nu) {
    .Call(`_eFCM_log_partialCn`, theta, data_u, u_star, dist_mat, nu)
}

Log_Lik_Non <- function(theta, data_u, dist_mat, nu) {
    .Call(`_eFCM_Log_Lik_Non`, theta, data_u, dist_mat, nu)
}

u_np <- function(Xvec) {
    .Call(`_eFCM_u_np`, Xvec)
}

model_likelihood <- function(theta0, data_u, coord, thres, nu, censorL) {
    .Call(`_eFCM_model_likelihood`, theta0, data_u, coord, thres, nu, censorL)
}

fit_initial <- function(coord, data, neigh) {
    .Call(`_eFCM_fit_initial`, coord, data, neigh)
}

