% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtlcor_sim.R
\name{dtl_app_sim}
\alias{dtl_app_sim}
\title{Simulation study for drop-the-losers (DTL) trial.}
\usage{
dtl_app_sim(
  nsim,
  alpha_t,
  D,
  N,
  n,
  mPFS,
  q,
  gamma,
  drop_rate,
  enroll,
  interim_t,
  sel_g_func = sel_g_func_default,
  ...
)
}
\arguments{
\item{nsim}{Number of replicates.}

\item{alpha_t}{significance level for the final stage (recommend to
use minimum significance level alpha_t to control
family-wise type I error rate).}

\item{D}{Total number of events.}

\item{N}{Total number of patients in both selected and control arms
at final analysis.}

\item{n}{Number of patients per treatment arm at the DTL look.}

\item{mPFS}{A 3-entry vector of median progression-free survival times
(in days) for control, low dose and high dose arms.}

\item{q}{A 3-entry vector of response rates under the null.}

\item{gamma}{Hazards ratio of responders and non-responders.}

\item{drop_rate}{Annual drop-out rate.}

\item{enroll}{Annual enrollment rate.}

\item{interim_t}{A vector of information fractions of final stage.}

\item{sel_g_func}{Arm-select function. The default function is
sel_g_func_default(W_2, W_1, delta). Users can define
their own arm-select function. The format of
the function must be function_name(W_2, W_1, ...). The
return values must be 1 (arm 1 is selected) or 2 (arm 2
is selected) or 0 (stop for futility).}

\item{...}{Other arguments from sel_g_func.}
}
\value{
A one row data frame of simulation results, including the parameter
settings, the O'Brien-Fleming boundaries for interim and final analyses:
c.1, c.2, the overall censoring rate: cen_rate, the mean study duration: dur,
the probability of selecting high dose / low dose / no dose: prob_sel_2,
prob_sel_1, prob_sel_0, the probability of rejecting
H_1 or H_2: rej_12, the probability of rejecting H_1 only: rej_1,
the probability of rejecting H_2 only: rej_2.
}
\description{
Simulation study for a trial based on the DTL design
}
\examples{
\donttest{
# Inputs
set.seed(1000)
nsim        = 1000
alpha_t     = 0.018
D           = 162
N           = 152  
n           = 80    
mPFS        = c(180, 276, 300)
q           = c(0.2, 0.4, 0.5)
mPFS_null   = rep(180, 3)
q_null      = rep(0.2, 3)
gamma       = 0.15
drop_rate   = 0.05
enroll      = 20 * 12
interim_t   = c(0.5, 1)
delta       = 0.05  

# Type I Error
dtl_app_sim(nsim, alpha_t, D, N, n, mPFS_null, q_null, gamma, drop_rate, 
            enroll, interim_t, delta = delta)

# Power
dtl_app_sim(nsim, alpha_t, D, N, n, mPFS, q, gamma, drop_rate, enroll, 
            interim_t, delta = delta)
}

}
