% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asTibbleDS.R
\name{asTibbleDS}
\alias{asTibbleDS}
\title{Coerce a data frame or matrix to a tibble}
\usage{
asTibbleDS(tidy_expr, x, .rows, .name_repair, rownames)
}
\arguments{
\item{tidy_expr}{Unused in present function.}

\item{x}{A data frame or matrix.}

\item{.rows}{The number of rows, useful to create a 0-column tibble or just as an additional
check.}

\item{.name_repair}{Treatment of problematic column names:
\itemize{
  \item "minimal": No name repair or checks, beyond basic existence.
  \item "unique": Make sure names are unique and not empty.
  \item "check_unique": (default value), no name repair, but check they are unique.
  \item "universal": Make the names unique and syntactic.
}}

\item{rownames}{How to treat existing row names of a data frame or matrix:
\itemize{
  \item `NULL`: remove row names. This is the default.
  \item `NA`: keep row names.
  \item A string: the name of a new column. Existing rownames are transferred
  into this column and the \code{row.names} attribute is deleted. No name repair is applied
  to the new column name, even if \code{x} already contains a column of that name.
}}
}
\value{
A tibble.
}
\description{
DataSHIELD implementation of \code{tibble::as_tibble}. Currently only implemented for data frames and matrices.
}
