% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.rename.R
\name{ds.rename}
\alias{ds.rename}
\title{Rename columns}
\usage{
ds.rename(df.name = NULL, tidy_expr = NULL, newobj = NULL, datasources = NULL)
}
\arguments{
\item{df.name}{Character specifying a serverside data frame or tibble.}

\item{tidy_expr}{List with format new_name = old_name to rename selected variables.}

\item{newobj}{Character specifying name for new server-side data frame.}

\item{datasources}{DataSHIELD connections object.}
}
\value{
No return value, called for its side effects. An object (typically a data frame or tibble)
with the name specified by \code{newobj} is created on the server.
}
\description{
DataSHIELD implentation of \code{dplyr::rename}.
}
\examples{
\dontrun{
## First log in to a DataSHIELD session with mtcars dataset loaded.

ds.rename(
  df.name = "mtcars",
  tidy_select = list(new_var_1 = mpg, new_var_2 = cyl),
  newobj = "df_renamed",
  dataources = conns
)

## Refer to the package vignette for more examples.
}
}
