% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.filter.R
\name{ds.filter}
\alias{ds.filter}
\title{Keep rows that match a condition}
\usage{
ds.filter(
  df.name = NULL,
  tidy_expr = NULL,
  .by = NULL,
  .preserve = FALSE,
  newobj = NULL,
  datasources = NULL
)
}
\arguments{
\item{df.name}{Character specifying a serverside data frame or tibble.}

\item{tidy_expr}{List of expressions that return a logical value, and are defined in terms of the
variables in \code{df.name}.}

\item{.by}{Optionally, a selection of columns to group by for just this operation, functioning as an alternative to \code{dplyr::group_by}}

\item{.preserve}{Relevant when the .data input is grouped. If .preserve = FALSE (the default),
the grouping structure is recalculated based on the resulting data, otherwise the grouping is
kept as is.}

\item{newobj}{Character specifying name for new server-side data frame.}

\item{datasources}{DataSHIELD connections object.}
}
\value{
No return value, called for its side effects. An object (typically a data frame or tibble)
with the name specified by \code{newobj} is created on the server.
}
\description{
DataSHIELD implentation of \code{dplyr::filter}.
}
\examples{
\dontrun{
ds.filter(
  df.name = "mtcars",
  tidy_expr = list(cyl == 4 & mpg > 20),
  newobj = "filtered",
  datasources = conns
)
}
}
