% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pr_eoi.R
\name{pr_eoi}
\alias{pr_eoi}
\title{Calculate Probability of Meeting Effect of Interest (EOI)}
\usage{
pr_eoi(x, eoi, dose, reference_dose = NULL, time = NULL)
}
\arguments{
\item{x}{output from a call to \code{dreamer_mcmc()}.}

\item{eoi}{a vector of the effects of interest (EOI) in the probability
function.}

\item{dose}{a vector of the doses for which to calculate the
posterior probabilities.}

\item{reference_dose}{a vector of doses for relative effects of interest.}

\item{time}{the time at which to calculate the posterior quantity.  Defaults
to the latest timepoint.  Applies to longitudinal models only.}
}
\value{
A tibble listing the doses, times, and
Pr(effect_dose - effect_reference_dose > eoi) if \code{reference_dose}
is specified; otherwise, Pr(effect_dose > eoi).
}
\description{
Calculate Pr(effect_dose - effect_reference_dose > EOI | data)
or Pr(effect_dose > EOI | data).
}
\examples{
set.seed(888)
data <- dreamer_data_linear(
  n_cohorts = c(20, 20, 20),
  dose = c(0, 3, 10),
  b1 = 1,
  b2 = 3,
  sigma = 5
)

# Bayesian model averaging
output <- dreamer_mcmc(
 data = data,
 n_adapt = 1e3,
 n_burn = 1e3,
 n_iter = 1e4,
 n_chains = 2,
 silent = FALSE,
 mod_linear = model_linear(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 ),
 mod_quad = model_quad(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   mu_b3 = 0,
   sigma_b3 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 )
)

pr_eoi(output, dose = 3, eoi = 10)

# difference of two doses
pr_eoi(output, dose = 3, eoi = 10, reference_dose = 0)

# single model
pr_eoi(output$mod_linear, dose = 3, eoi = 10)
}
