% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglogistic5.R
\name{loglogistic5_gradient_2}
\alias{loglogistic5_gradient_2}
\alias{loglogistic5_hessian_2}
\alias{loglogistic5_gradient_hessian_2}
\title{5-parameter log-logistic function gradient and Hessian}
\usage{
loglogistic5_gradient_2(x, theta)

loglogistic5_hessian_2(x, theta)

loglogistic5_gradient_hessian_2(x, theta)
}
\arguments{
\item{x}{numeric vector at which the function is to be evaluated.}

\item{theta}{numeric vector with the five parameters in the form
\code{c(alpha, delta, eta, phi, nu)}.}
}
\value{
Gradient or Hessian of the alternative parameterization evaluated at
the specified point.
}
\description{
Evaluate at a particular set of parameters the gradient and Hessian of the
5-parameter log-logistic function.
}
\details{
The 5-parameter log-logistic function \verb{f(x; theta)} is defined here as

\verb{g(x; theta) = (x^eta / (x^eta + nu * phi^eta))^(1 / nu)}
\verb{f(x; theta) = alpha + delta g(x; theta)}

where \code{x >= 0}, \code{theta = c(alpha, delta, eta, phi, nu)}, \code{eta > 0},
\code{phi > 0}, and \code{nu > 0}.

This set of functions use a different parameterization from
\code{link[drda]{loglogistic5_gradient}}. To avoid the non-negative
constraints of parameters, the gradient and Hessian computed here are for
the function with \code{eta2 = log(eta)}, \code{phi2 = log(phi)}, and \code{nu2 = log(nu)}.

Note that argument \code{theta} is on the original scale and not on the log scale.
}
