% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{heatm}
\alias{heatm}
\title{Heatmap of a partition in a reduced subspace}
\usage{
heatm(data, drclust_out)
}
\arguments{
\item{data}{Units x variables data matrix.}

\item{drclust_out}{Out of either doublekm, redkm, factkm or dpcakm.}
}
\value{
No return value, called for side effects
}
\description{
Plots the heatmap of a partition on a reduced subspace obtained via either: doublekm, redkm, factkm or dpcakm.
}
\examples{
# Iris data 
# Loading the numeric variables of iris data
iris <- as.matrix(iris[,-5]) 

# standardizing the data
iris <- scale(iris)

# applying a clustering algorithm
drclust_out <- dpcakm(iris, 20, 3)

# obtain a heatmap based on the output of the clustering algorithm and the data
h <- heatm(iris, drclust_out)

}
\references{
Kolde R. (2019) "pheatmap: Pretty Heatmaps" <https://cran.r-project.org/web/packages/pheatmap/index.html>
}
\author{
Ionel Prunila, Maurizio Vichi
}
