% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan_helpers.R
\name{knitr_in}
\alias{knitr_in}
\title{Declare \code{knitr}/\code{rmarkdown} source files
as dependencies.
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}}
\usage{
knitr_in(...)
}
\arguments{
\item{...}{Character strings. File paths of \code{knitr}/\code{rmarkdown}
source files supplied to a command in your workflow plan data frame.}
}
\value{
A character vector of declared input file paths.
}
\description{
\code{knitr_in()} marks individual \code{knitr}/R Markdown
reports as dependencies. In \code{drake}, these reports are pieces
of the pipeline. R Markdown is a great tool for \emph{displaying}
precomputed results, but not for running a large workflow
from end to end. These reports should do as little
computation as possible.
}
\details{
Unlike \code{\link[=file_in]{file_in()}} and \code{\link[=file_out]{file_out()}}, \code{knitr_in()}
does not work with entire directories.
}
\section{Keywords}{

\code{\link[=drake_plan]{drake_plan()}} understands special keyword functions for your commands.
With the exception of \code{\link[=target]{target()}}, each one is a proper function
with its own help file.
\itemize{
\item \code{\link[=target]{target()}}: give the target more than just a command.
Using \code{\link[=target]{target()}}, you can apply a transformation
(examples: \verb{https://books.ropensci.org/drake/plans.html#large-plans}), # nolint
supply a trigger (\verb{https://books.ropensci.org/drake/triggers.html}), # nolint
or set any number of custom columns.
\item \code{\link[=file_in]{file_in()}}: declare an input file dependency.
\item \code{\link[=file_out]{file_out()}}: declare an output file to be produced
when the target is built.
\item \code{\link[=knitr_in]{knitr_in()}}: declare a \code{knitr} file dependency such as an
R Markdown (\verb{*.Rmd}) or R LaTeX (\verb{*.Rnw}) file.
\item \code{\link[=ignore]{ignore()}}: force \code{drake} to entirely ignore a piece of code:
do not track it for changes and do not analyze it for dependencies.
\item \code{\link[=no_deps]{no_deps()}}: tell \code{drake} to not track the dependencies
of a piece of code. \code{drake} still tracks the code itself for changes.
\item \code{\link[=id_chr]{id_chr()}}: Get the name of the current target.
\item \code{\link[=drake_envir]{drake_envir()}}: get the environment where drake builds targets.
Intended for advanced custom memory management.
}
}

\examples{
\dontrun{
isolate_example("contain side effects", {
if (requireNamespace("knitr", quietly = TRUE)) {
# `knitr_in()` is like `file_in()`
# except that it analyzes active code chunks in your `knitr`
# source file and detects non-file dependencies.
# That way, updates to the right dependencies trigger rebuilds
# in your report.
# The mtcars example (`drake_example("mtcars")`)
# already has a demonstration

load_mtcars_example()
make(my_plan)

# Now how did drake magically know that
# `small`, `large`, and `coef_regression2_small` were
# dependencies of the output file `report.md`?
# because the command in the workflow plan had
# `knitr_in("report.Rmd")` in it, so drake knew
# to analyze the active code chunks. There, it spotted
# where `small`, `large`, and `coef_regression2_small`
# were read from the cache using calls to `loadd()` and `readd()`.
}
})
}
}
\seealso{
\code{\link[=file_in]{file_in()}}, \code{\link[=file_out]{file_out()}}, \code{\link[=ignore]{ignore()}}, \code{\link[=no_deps]{no_deps()}}
}
