% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paragraph2vec.R
\name{write.paragraph2vec}
\alias{write.paragraph2vec}
\title{Save a paragraph2vec model to disk}
\usage{
write.paragraph2vec(x, file)
}
\arguments{
\item{x}{an object of class \code{paragraph2vec} or \code{paragraph2vec_trained} as returned by \code{\link{paragraph2vec}}}

\item{file}{the path to the file where to store the model}
}
\value{
invisibly a logical if the resulting file exists and has been written on your hard disk
}
\description{
Save a paragraph2vec model as a binary file to disk
}
\examples{
\dontshow{if(require(tokenizers.bpe))\{}
library(tokenizers.bpe)
data(belgium_parliament, package = "tokenizers.bpe")
x <- subset(belgium_parliament, language \%in\% "french")
x <- subset(x, nchar(text) > 0 & txt_count_words(text) < 1000)

\donttest{
model <- paragraph2vec(x = x, type = "PV-DM",   dim = 100, iter = 20)
model <- paragraph2vec(x = x, type = "PV-DBOW", dim = 100, iter = 20)
}
\dontshow{
model <- paragraph2vec(x = head(x, 5), 
                       type = "PV-DM", dim = 5, iter = 1, min_count = 0)
}
path <- "mymodel.bin"
\dontshow{
path <- tempfile(pattern = "paragraph2vec", fileext = ".bin")
}
write.paragraph2vec(model, file = path)
model <- read.paragraph2vec(file = path)

vocab <- summary(model, type = "vocabulary", which = "docs")
vocab <- summary(model, type = "vocabulary", which = "words")
embedding <- as.matrix(model, which = "docs")
embedding <- as.matrix(model, which = "words")
\dontshow{
file.remove(path)
}
\dontshow{\} # End of main if statement running only if the required packages are installed}
}
\seealso{
\code{\link{paragraph2vec}}
}
