% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pc_level_calc.R
\name{pc_level_calc}
\alias{pc_level_calc}
\title{Calculate Player Character (PC) Level from Current Experience Points (XP)}
\usage{
pc_level_calc(player_xp = NULL)
}
\arguments{
\item{player_xp}{(numeric) total value of experience points earned by one player}
}
\value{
(dataframe) current player level, XP threshold for that level, and the proficiency modifier used at that level
}
\description{
Uses total player experience points (XP) to identify player character (PC) level and proficiency modifier. Only works for a single PC at a time (though this is unlikely to be an issue if all party members have the same amount of XP). Big thanks to Humberto Nappo for contributing this function!
}
\examples{
# Calculate player level from XP earned
dndR::pc_level_calc(player_xp = 950)

}
