#' @title Evenness index
#'
#' @description Modification of Simpson's evenness index to be restricted between 0 an 1
#'
#' @param x Vector of dimension S (spicies) with the numbers of observed individuals in each spicy. NA values are allowed. 0 values are converted to NA.
#'
#' @return Evenness index.
#'
#' @seealso \link{simpson_E}
#'
#' @references
#' "Quantifying Diversity through Entropy Decomposition: Insights into Hominin Occupation and Carcass Processing at Qesem cave"
#'
#' @examples
#' data(Qesem_s)
#' evenness(Qesem_s$HU)
#'
#' @export
evenness <- function(x){
  return(1-dominance(x))
}
