% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{coverage}
\alias{coverage}
\alias{coverage.numeric}
\alias{coverage.abundances}
\alias{coverage_to_size}
\alias{coverage_to_size.numeric}
\alias{coverage_to_size.abundances}
\title{Sample Coverage of a Community}
\usage{
coverage(x, ...)

\method{coverage}{numeric}(
  x,
  estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  level = NULL,
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{coverage}{abundances}(
  x,
  estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  level = NULL,
  ...,
  check_arguments = TRUE
)

coverage_to_size(x, ...)

\method{coverage_to_size}{numeric}(
  x,
  sample_coverage,
  estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{coverage_to_size}{abundances}(
  x,
  sample_coverage,
  estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object.}

\item{...}{Unused.}

\item{estimator}{An estimator of the sample coverage.
"ZhangHuang" is the most accurate but does not allow choosing a \code{level}.
"Good"'s estimator only allows interpolation, i.e. estimation of the coverage
of a subsample.
"Chao" allows estimation at any \code{level}, including extrapolation.
"Turing" is the simplest estimator, equal to 1 minus the number of singletons
divided by the sample size.}

\item{level}{The level of interpolation or extrapolation, i.e. an abundance.}

\item{as_numeric}{if \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{sample_coverage}{The target sample coverage.}
}
\value{
\code{coverage()} returns a named number equal to the calculated sample coverage.
The name is that of the estimator used.

\code{coverage_to_size()} returns a number equal to the sample size corresponding
to the chosen sample coverage.
}
\description{
\code{coverage()} calculates an estimator of the sample coverage of a community
described by its abundance vector.
\code{coverage_to_size()} estimates the sample size corresponding to the chosen
sample coverage.
}
\details{
The sample coverage \eqn{C} of a community is the total probability of
occurrence of the species observed in the sample.
\eqn{1-C} is the probability for an individual of the whole community to
belong to a species that has not been sampled.

The historical estimator is due to Turing \insertCite{Good1953}{divent}.
It only relies on singletons (species observed only once).
Chao's \insertCite{Chao2010a}{divent} estimator uses doubletons too and
Zhang-Huang's \insertCite{Chao1988,Zhang2007}{divent} uses the whole
distribution.

If \code{level} is not \code{NULL}, the sample coverage is interpolated or extrapolated.
Interpolation by the Good estimator relies on the equality between sampling
deficit and the generalized Simpson entropy \insertCite{Good1953}{divent}.
The \insertCite{Chao2014;textual}{divent} estimator allows extrapolation,
reliable up a level equal to the double size of the sample.
}
\examples{
coverage(paracou_6_abd)
coverage_to_size(paracou_6_abd, sample_coverage = 0.9)

}
\references{
\insertAllCited{}
}
