% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovr_data.R
\docType{data}
\name{daniels_2012}
\alias{daniels_2012}
\title{Daniels (2012) data}
\format{
A tibble with 4 rows and 7 variables.
}
\source{
\href{https://www.discovr.rocks/csv/daniels_2012.csv}{www.discovr.rocks/csv/daniels_2012.csv}
}
\usage{
daniels_2012
}
\description{
A dataset from Field, A. P. (2026). Discovering statistics using R and RStudio (2nd ed.). London: Sage.
}
\details{
Women (and increasingly men) are bombared with 'idealized' images in the media and there is a growing concern
about how these images affect our perceptions of ourselves. Daniels (2012) showed young women images of successful
female athletes (e.g., Anna Kournikova) in which they were either playing sport (performance athlete images) or posing
in bathing suits (sexualized images). Participants completed a short writing exercise after viewing these images.
Each participant saw only one type of image, but several examples. Daniels then coded these written exercises and
identified themes, one of which was whether women self-objectified (i.e., commented on their own appearance/attractiveness).
Daniels hypothesized that women who viewed the sexualized images (\emph{n} = 140) would self-objectify
(i.e., this theme would be present in what they wrote) more than those who viewed the performance athlete pictures (\emph{n} = 117,
despite what the participants Section of the paper implies).  These are the data from that study. The data contains the following variables:
\itemize{
\item \strong{picture}: Whether the picture was of a performance athlete or a sexualized athlete
\item \strong{theme_present}: whether a particular theme was present or absent from the participant's writing exercise
\item \strong{athletes_body}: frequencies for the theme of the athlete's body
\item \strong{admiration}: frequencies for the theme of admiration for the athlete
\item \strong{role_model}: frequencies for the theme of the athlete being a role model
\item \strong{self_evaluation}: frequencies for the theme of self-evaluation
\item \strong{self_physical_activity}: frequencies for the theme of self physical activity
}
}
\references{
\itemize{
\item Daniels, E. (2012). Sexy versus strong: What girls and women think of female athletes. \emph{Journal of Applied Developmental Psychology}, 33, 79–90. \doi{10.1016/j.appdev.2011.12.002}
}
}
\keyword{datasets}
