% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols.R
\name{dfadjustSE}
\alias{dfadjustSE}
\title{Standard Errors with adjusted degrees of freedom}
\usage{
dfadjustSE(
  model,
  clustervar = NULL,
  ell = NULL,
  IK = TRUE,
  tol = 1e-09,
  rho0 = FALSE
)
}
\arguments{
\item{model}{Fitted model returned by the \code{lm} function}

\item{clustervar}{Factor variable that defines clusters. If \code{NULL} (or
not supplied), the command computes heteroscedasticity-robust standard
errors, rather than cluster-robust standard errors.}

\item{ell}{A vector specifying for which coefficients to compute the standard
errors. If \code{NULL}, compute standard errors for each regressor
coefficient. If \code{ell} consists of integers and its length is smaller
than the number of regressors, compute standard errors for those
coefficients. If the vector has the same length as the dimension of
regressors, compute standard error for the linear combination
\eqn{\ell'\beta}{ell'beta} of coefficients \eqn{\beta}{beta}.}

\item{IK}{Only relevant for cluster-robust standard errors. Specifies whether
to compute the degrees-of-freedom adjustment using the Imbens-Kolesár
(2016) method (if \code{TRUE}), or the Bell-McCaffrey (2002) method (if
\code{FALSE}).}

\item{tol}{Numerical tolerance for determining whether an eigenvalue equals
zero.}

\item{rho0}{Impose positive \eqn{\rho}{rho} when estimating the Moulton
(1986) model when implementing the \code{IK} method?}
}
\value{
Returns a list with the following components \describe{

\item{vcov}{Variance-covariance matrix estimator. For independent errors, it
corresponds to the HC2 estimator (see MacKinnon and White, 1985, or the
reference manual for the \code{sandwich} package). For clustered errors, it
corresponds to a version the generalization of the HC2 estimator, called LZ2
in Imbens and Kolesár.}

\item{coefficients}{Matrix of estimated coefficients, along with HC1, and HC2
standard errors, Adjusted standard errors, and effective degrees of freedom.
Adjusted standard error is HC2 standard error multiplied by \code{qt(0.975,
df=dof)/qnorm(0.975)} so that one can construct 95\% confidence intervals by
adding and subtracting 1.96 times the adjusted standard error.}

\item{rho, sig}{Estimates of \eqn{\rho} and \eqn{\sigma} of the Moulton
(1986) model for the regression errors. Only computed if \code{IK} method is
used}

}
}
\description{
Standard Errors with adjusted degrees of freedom
}
\examples{
## No clustering:
x <- sin(1:100)
y <- 1:100
fm <- lm(y ~ x + I(x^2))
dfadjustSE(fm)
## Clustering, with 5 clusters
clustervar <- as.factor(c(rep(1, 40), rep(5, 20),
                        rep(2, 20), rep(3, 10), rep(4, 10)))
dfadjustSE(fm, clustervar)
## Only compute standard errors for the second coefficient
dfadjustSE(fm, clustervar, ell=2)
## Compute standard error for the sum of second and third coefficient
dfadjustSE(fm, clustervar, ell=c(0, 1, 1))
}
\references{
{

\cite{Robert M. Bell and Daniel F. McCaffrey. Bias reduction in standard
errors for linear regression with multi-stage samples. Survey Methodology,
28(2):169–181, December 2002.}

\cite{Guido W. Imbens and Michal Kolesár. Robust standard errors in small
samples: Some practical advice. Review of Economics and Statistics,
98(4):701–712, October 2016. \doi{10.1162/REST_a_00552}}

\cite{James G. MacKinnon and Halbert White. Some
Heteroskedasticity-Consistent Covariance Matrix Estimators with Improved
Finite Sample Properties. Journal of Econometrics, (29)3:305–325, September
1985. \doi{10.1016/0304-4076(85)90158-7}}

\cite{Brent R. Moulton. Random group effects and the precision of regression
estimates. Journal of Econometrics, 32(3):385–397, August 1986.
\doi{10.1016/0304-4076(86)90021-7}.}

}
}
