#' @keywords internal

validate_density.weights <- function(density.weights) {
  if (length(density.weights) != length(L)) {
    stop("Length of density.weights must be equal to the number of densities.")
  }

  if (any(density.weights < 0)) {
    stop("All values in density.weights must be greater than or equal to 0.")
  }

  if (all(density.weights == 0)) {
    stop("At least one value in density.weights must be greater than 0.")
  }

  density.weights <- density.weights / sum(density.weights)

  return(density.weights)
}

validate_real.imag.weights <- function(real.imag.weights) {
  if (length(real.imag.weights) != 2) {
    stop("real.imag.weights must be a vector of length 2.")
  }

  if (any(real.imag.weights < 0)) {
    stop("All values in real.imag.weights must be greater than or equal to 0.")
  }

  if (all(real.imag.weights == 0)) {
    stop("At least one value in real.imag.weights must be greater than 0.")
  }

  real.imag.weights <- real.imag.weights / sum(real.imag.weights)

  return(real.imag.weights)
}

validate_moment.weights <- function(moment, m.weights) {
  if (moment == "combined") {
    if (length(m.weights) != 4) {
      stop("moment.weights must be a vector of length 4.")
    }

    if (any(m.weights < 0)) {
      stop("moment.weights can only contain positive values or zeros.")
    }

    if (all(m.weights == 0)) {
      stop("moment.weights cannot consist entirely of zeros.")
    }

    m.weights <- m.weights / sum(m.weights)
  } else {
    m.weights <- switch(
      moment,
      "expectation" = c(1, 0, 0, 0),
      "variance" = c(0, 1, 0, 0),
      "skewness" = c(0, 0, 1, 0),
      "kurtosis" = c(0, 0, 0, 1),
      stop("Invalid moment. Valid options are 'expectation', 'variance', 'skewness', 'kurtosis', or 'combined'.")
    )
  }

  return(m.weights)
}
