#' @keywords internal

numerical_integration <- function(x, fx, func) {
  a <- min(x)
  b <- max(x)
  (b - a) / length(x) * sum(func(x) * fx)
}

compute_expectation <- function(x, y) {
  numerical_integration(x, y, function(x) x)
}

compute_variance <- function(x, y) {
  expectation <- compute_expectation(x, y)
  numerical_integration(x, y, function(x) (x - expectation)^2)
}

compute_skewness <- function(x, y) {
  expectation <- compute_expectation(x, y)
  variance <- compute_variance(x, y)
  numerical_integration(x, y, function(x) (x - expectation)^3) / (variance^(3 / 2))
}

compute_kurtosis <- function(x, y) {
  expectation <- compute_expectation(x, y)
  variance <- compute_variance(x, y)
  numerical_integration(x, y, function(x) (x - expectation)^4) / (variance^2)
}

normalize_moments <- function(D) {
  return(D / max(D))
}
