% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grouped_shuffler.R
\name{GroupedShuffler}
\alias{GroupedShuffler}
\title{GroupedShuffler class for applying 'shuffling' transform with data
aggregated}
\arguments{
\item{limit}{Minimum number of rows required to shuffle data}

\item{data}{A data frame to be manipulated}

\item{...}{Vector of variables in 'data' to transform.}
}
\description{
Convert \code{self} to a list.

Character representation of the class
}
\details{
'Shuffling' refers to the a random sampling of a variable without
replacement e.g. [A, B, C] becoming [B, A, C] but not [A, A, B].  "Grouped
shuffling" refers to aggregating the data by another feature before applying
the shuffling process.  Grouped shuffling will preserve aggregate level
metrics (e.g. mean, median, mode) but removes ordinal properties
i.e. correlations and auto-correlations
}
\section{Fields}{

\describe{
\item{\code{group_on}}{Symbolic representation of grouping variables}

\item{\code{limit}}{Minimum number of rows required to shuffle data
Create new GroupedShuffler object}
}}

