% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadForm.R
\name{quadForm}
\alias{quadForm}
\title{Evaluate quadratic form}
\usage{
quadForm(ecl, A, alpha = -1/2)
}
\arguments{
\item{ecl}{estimate of covariance/correlation matrix from \code{eclairs} storing \eqn{U}, \eqn{d_1^2}, \eqn{\lambda} and \eqn{\nu}}

\item{A}{matrix}

\item{alpha}{default = -1/2.  Exponent of eigen-values}
}
\value{
scalar value
}
\description{
Evaluate quadratic form
}
\details{
Evaluate quadratic form \eqn{A^T \Sigma^{2\alpha} A}
}
\examples{
library(Rfast)
n <- 800 # number of samples
p <- 200 # number of features

# create correlation matrix
Sigma <- autocorr.mat(p, .9)

# draw data from correlation matrix Sigma
Y <- rmvnorm(n, rep(0, p), sigma = Sigma * 5.1, seed = 1)

# eclairs decomposition
ecl <- eclairs(Y)

# return scalar
quadForm(ecl, Y[1, ])

# return matrix
quadForm(ecl, Y[1:2, ])

}
