% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_datatype_matrix.R
\name{int_datatype_matrix}
\alias{int_datatype_matrix}
\title{Check declared data types of metadata in study data}
\usage{
int_datatype_matrix(
  resp_vars = NULL,
  study_data,
  label_col,
  item_level = "item_level",
  split_segments = FALSE,
  max_vars_per_plot = 20,
  threshold_value = 0,
  meta_data = item_level,
  meta_data_v2
)
}
\arguments{
\item{resp_vars}{\link{variable} the names of the measurement variables, if
missing or \code{NULL}, all variables will be checked}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{split_segments}{\link{logical} return one matrix per study segment}

\item{max_vars_per_plot}{\link{integer} from=0. The maximum number of variables
per single plot.}

\item{threshold_value}{\link{numeric} from=0 to=100. percentage failing
conversions allowed to still classify a
study variable convertible.}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}
}
\value{
a list with:
\itemize{
\item \code{SummaryTable}: data frame containing data quality check for
"data type mismatch" (\code{CLS_int_vfe_type},
\code{PCT_int_vfe_type}). The following categories are possible:
categories: "Non-matching datatype",
"Non-Matching datatype, convertible",
"Matching datatype"
\item \code{SummaryData}: data frame containing data quality check for
"data type mismatch" for a report
\item \code{SummaryPlot}: \link[ggplot2:ggplot2-package]{ggplot2::ggplot2} heatmap plot, graphical representation of
\code{SummaryTable}
\item \code{DataTypePlotList}: \link{list} of plots per (maybe artificial) segment
\item \code{ReportSummaryTable}: data frame underlying \code{SummaryPlot}
}
}
\description{
Checks data types of the study data and for the data type
declared in the metadata

\link{Indicator}
}
\details{
This is a preparatory support function that compares study data with
associated metadata. A prerequisite of this function is that the no. of
columns in the study data complies with the no. of rows in the metadata.

For each study variable, the function searches for its data type declared in
static metadata and returns a heatmap like matrix indicating data type
mismatches in the study data.

List function.
}
