% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq_report_by.R
\name{dq_report_by}
\alias{dq_report_by}
\title{Generate a stratified full DQ report}
\usage{
dq_report_by(
  study_data,
  item_level = "item_level",
  meta_data_segment = "segment_level",
  meta_data_dataframe = "dataframe_level",
  meta_data_cross_item = "cross-item_level",
  meta_data_item_computation = "item_computation_level",
  missing_tables = NULL,
  label_col,
  meta_data_v2,
  segment_column = NULL,
  strata_column = NULL,
  strata_select = NULL,
  selection_type = NULL,
  segment_select = NULL,
  segment_exclude = NULL,
  strata_exclude = NULL,
  subgroup = NULL,
  resp_vars = character(0),
  id_vars = NULL,
  advanced_options = list(),
  storr_factory = NULL,
  amend = FALSE,
  ...,
  output_dir = NULL,
  input_dir = NULL,
  also_print = FALSE,
  disable_plotly = FALSE,
  view = TRUE,
  meta_data = item_level,
  cross_item_level,
  `cross-item_level`,
  segment_level,
  dataframe_level,
  item_computation_level
)
}
\arguments{
\item{study_data}{\link{data.frame} the data frame that contains the measurements:
it can be an R object (e.g., \code{bia}), a
data frame (e.g., \code{"C:/Users/data/bia.dta"}),
a vector containing data frames files (e.g.,
c(\code{"C:/Users/data/bia.dta"},
\verb{C:/Users/data/biames.dta"})), or it can be
left empty and the data frames are provided
in the data frame level metadata. If only the
file name without path is provided
(e.g., \code{"bia.dta"}), the file
name needs the extension and the path must be
provided in the argument \code{input_dir}. It can
also contain only the file name in case of
example data from the package \code{dataquieR}
(e.g., \code{"study_data"} or \code{"ship"})}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{meta_data_segment}{\link{data.frame} -- optional: Segment level metadata}

\item{meta_data_dataframe}{\link{data.frame} -- optional if \code{study_data} is
present: Data frame level metadata}

\item{meta_data_cross_item}{\link{data.frame} -- optional: Cross-item level
metadata}

\item{meta_data_item_computation}{\link{data.frame} -- optional: Computed items
metadata}

\item{missing_tables}{\link{character} the name of the data frame containing the
missing codes, it can be a vector if more
than one table is provided. Example:
\code{c("missing_table1", "missing_table2")}}

\item{label_col}{\link{variable attribute} the name of the column in the
metadata containing the labels of
the variables}

\item{meta_data_v2}{\link{character} path or file name of the workbook like
metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}}

\item{segment_column}{\link{variable attribute} name of a metadata attribute
usable to split the report in
sections of variables, e.g. all
blood-pressure related variables.
By default,
reports are split by
\link{STUDY_SEGMENT} if available and
no segment_column nor
strata_column or subgroup
are defined.
To create an un-split report
please write explicitly
the argument
'segment_column = NULL'}

\item{strata_column}{\link{variable} name of a study variable to stratify the
report by, e.g. the study centers.
Both labels and \code{VAR_NAMES} are accepted.
In case of NAs in the selected variable,
a separate report containing the NAs
subset will be created}

\item{strata_select}{\link{character} if given, the strata of strata_column
are limited to the content of this
vector. A character vector or a regular
expression can be provided
(e.g., "^a.*$"). This argument can not
be used if no strata_column is
provided}

\item{selection_type}{\link{character} optional, can only be specified if a
\code{strata_select} or
\code{strata_exclude} is specified.
If not present the
function try to guess what the
user typed as \code{strata_select} or
\code{strata_exclude}.
There are 3 options:
\code{value} indicating that the
stratum selected is a value and
not a value_label.
For example \code{"0"};
\code{v_label} indicating that the
stratum specified is a label.
For example \code{"male"}.
\code{regex} indicating that the user
specified strata using a regular
expression. For example \code{"^Ber"}
to select all strata starting
with that letters}

\item{segment_select}{\link{character} if given, the levels of segment_column
are limited to the content of this
vector. A character vector or a
regular expression (e.g., ".*_EXAM$")
can be provided.
This argument can not be used if no
segment_column is provided.}

\item{segment_exclude}{\link{character} optional, can only be specified if a
\code{segment_column} is specified.
The levels of \code{segment_column}
will not include the content of
this argument.
A character vector or
a regular  expression can be
provided  (e.g., "^STU").}

\item{strata_exclude}{\link{character} optional, can only be specified if a
\code{strata_column} is specified.
The strata of \code{strata_column}
will not include the content of
this argument.
A character vector or
a regular  expression can be
provided  (e.g., "^STU").}

\item{subgroup}{\link{character} optional, to define subgroups of cases. Rules are
to be written as \code{REDCap} rules.
Only VAR_NAMES are accepted in the rules.}

\item{resp_vars}{\link{variable} the names of the measurement variables, if
missing or \code{NULL}, all variables will be included}

\item{id_vars}{\link{variable} a vector containing the name/s of the variables
containing ids, to
be used to merge multiple data frames if provided
in \code{study_data} and to be add to referred vars}

\item{advanced_options}{\link{list} options to set during report computation,
see \code{\link[=options]{options()}}}

\item{storr_factory}{\link{function} \code{NULL}, or
a function returning a \code{storr} object as
back-end for the report's results. If used with
\code{cores > 1}, the storage must be accessible from all
cores and capable of concurrent writing according
to \code{storr}. Hint: \code{dataquieR} currently only supports
\code{storr::storr_rds()}, officially, while other back-
ends may nevertheless work, yet, they are not tested.}

\item{amend}{\link{logical} if there is already data in.\code{storr_factory},
use it anyways -- unsupported, so far!}

\item{...}{arguments to be passed through to \link{dq_report} or \link{dq_report2}}

\item{output_dir}{\link{character} if given, the output is not returned but saved
in this directory}

\item{input_dir}{\link{character} if given, the study data files that have
no path and that are not URL are searched in
this directory. Also \code{meta_data_v2} is searched
in this directory if no path is provided}

\item{also_print}{\link{logical} if \code{output_dir} is not \code{NULL}, also create
\code{HTML} output for each report using
\code{\link[=print.dataquieR_resultset2]{print.dataquieR_resultset2()}}
written to the path \code{output_dir}}

\item{disable_plotly}{\link{logical} do not use \code{plotly}, even if installed}

\item{view}{\link{logical} open the returned report}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{cross_item_level}{\link{data.frame} alias for \code{meta_data_cross_item}}

\item{segment_level}{\link{data.frame} alias for \code{meta_data_segment}}

\item{dataframe_level}{\link{data.frame} alias for \code{meta_data_dataframe}}

\item{item_computation_level}{\link{data.frame} alias for
\code{meta_data_item_computation}}

\item{`cross-item_level`}{\link{data.frame} alias for \code{meta_data_cross_item}}
}
\value{
\code{\link[=invisible]{invisible()}}. named \link{list} of named \link{list}s of \link{dq_report2} reports
or, if \code{output_dir} has been specified, \code{invisible(NULL)}
}
\description{
Generate a stratified full DQ report
}
\examples{
\dontrun{ # really long-running example.
prep_load_workbook_like_file("meta_data_v2")
rep <- dq_report_by("study_data", label_col =
  LABEL, strata_column = "CENTER_0")
rep <- dq_report_by("study_data",
  label_col = LABEL, strata_column = "CENTER_0",
  segment_column = NULL
)
unlink("/tmp/testRep/", force = TRUE, recursive = TRUE)
dq_report_by("study_data",
  label_col = LABEL, strata_column = "CENTER_0",
  segment_column = STUDY_SEGMENT, output_dir = "/tmp/testRep"
)
unlink("/tmp/testRep/", force = TRUE, recursive = TRUE)
dq_report_by("study_data",
  label_col = LABEL, strata_column = "CENTER_0",
  segment_column = NULL, output_dir = "/tmp/testRep"
)
dq_report_by("study_data",
  label_col = LABEL,
  segment_column = STUDY_SEGMENT, output_dir = "/tmp/testRep"
)
dq_report_by("study_data",
  label_col = LABEL,
  segment_column = STUDY_SEGMENT, output_dir = "/tmp/testRep",
  also_print = TRUE
)
dq_report_by(study_data = "study_data", meta_data_v2 = "meta_data_v2",
  advanced_options = list(dataquieR.study_data_cache_max = 0,
  dataquieR.study_data_cache_metrics = TRUE,
  dataquieR.study_data_cache_metrics_env = environment()),
  cores = NULL, dimensions = "int")
dq_report_by(study_data = "study_data", meta_data_v2 = "meta_data_v2",
  advanced_options = list(dataquieR.study_data_cache_max = 0),
  cores = NULL, dimensions = "int")
}
}
\seealso{
\link{dq_report}
}
