% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KLDivergence.R
\name{KLDivergence}
\alias{KLDivergence}
\title{Kullback-Leibler Divergence (KLD) for Change Detection}
\description{
Implements the Kullback-Leibler Divergence (KLD) calculation between two probability distributions
using histograms. The class can detect drift by comparing the divergence to a predefined threshold.
}
\details{
The Kullback-Leibler Divergence (KLD) is a measure of how one probability distribution diverges from a second,
expected probability distribution. This class uses histograms to approximate the distributions and calculates the
KLD to detect changes over time. If the divergence exceeds a predefined threshold, it signals a detected drift.
}
\examples{
set.seed(123)  # Setting a seed for reproducibility
initial_data <- c(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0)
kld <- KLDivergence$new(bins = 10, drift_level = 0.2)
kld$set_initial_distribution(initial_data)

new_data <- c(0.2, 0.2, 0.3, 0.4, 0.4, 0.5, 0.6, 0.7, 0.7, 0.8)
kld$add_distribution(new_data)

kl_result <- kld$get_kl_result()
message(paste("KL Divergence:", kl_result))

if (kld$is_drift_detected()) {
  message("Drift detected.")
}
}
\references{
Kullback, S., and Leibler, R.A. (1951). On Information and Sufficiency. Annals of Mathematical Statistics, 22(1), 79-86.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{epsilon}}{Value to add to small probabilities to avoid log(0) issues.}

\item{\code{base}}{The base of the logarithm used in KLD calculation.}

\item{\code{bins}}{Number of bins used for the histogram.}

\item{\code{drift_level}}{The threshold for detecting drift.}

\item{\code{drift_detected}}{Boolean indicating if drift has been detected.}

\item{\code{p}}{Initial distribution.}

\item{\code{kl_result}}{The result of the KLD calculation.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KLDivergence-new}{\code{KLDivergence$new()}}
\item \href{#method-KLDivergence-reset}{\code{KLDivergence$reset()}}
\item \href{#method-KLDivergence-set_initial_distribution}{\code{KLDivergence$set_initial_distribution()}}
\item \href{#method-KLDivergence-add_distribution}{\code{KLDivergence$add_distribution()}}
\item \href{#method-KLDivergence-calculate_kld}{\code{KLDivergence$calculate_kld()}}
\item \href{#method-KLDivergence-get_kl_result}{\code{KLDivergence$get_kl_result()}}
\item \href{#method-KLDivergence-is_drift_detected}{\code{KLDivergence$is_drift_detected()}}
\item \href{#method-KLDivergence-clone}{\code{KLDivergence$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KLDivergence-new"></a>}}
\if{latex}{\out{\hypertarget{method-KLDivergence-new}{}}}
\subsection{Method \code{new()}}{
Initializes the KLDivergence class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KLDivergence$new(epsilon = 1e-10, base = exp(1), bins = 10, drift_level = 0.2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{epsilon}}{Value to add to small probabilities to avoid log(0) issues.}

\item{\code{base}}{The base of the logarithm used in KLD calculation.}

\item{\code{bins}}{Number of bins used for the histogram.}

\item{\code{drift_level}}{The threshold for detecting drift.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KLDivergence-reset"></a>}}
\if{latex}{\out{\hypertarget{method-KLDivergence-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the internal state of the detector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KLDivergence$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KLDivergence-set_initial_distribution"></a>}}
\if{latex}{\out{\hypertarget{method-KLDivergence-set_initial_distribution}{}}}
\subsection{Method \code{set_initial_distribution()}}{
Sets the initial distribution.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KLDivergence$set_initial_distribution(initial_p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{initial_p}}{The initial distribution.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KLDivergence-add_distribution"></a>}}
\if{latex}{\out{\hypertarget{method-KLDivergence-add_distribution}{}}}
\subsection{Method \code{add_distribution()}}{
Adds a new distribution and calculates the KLD.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KLDivergence$add_distribution(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{The new distribution.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KLDivergence-calculate_kld"></a>}}
\if{latex}{\out{\hypertarget{method-KLDivergence-calculate_kld}{}}}
\subsection{Method \code{calculate_kld()}}{
Calculates the KLD between two distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KLDivergence$calculate_kld(p, q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{The initial distribution.}

\item{\code{q}}{The new distribution.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The KLD value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KLDivergence-get_kl_result"></a>}}
\if{latex}{\out{\hypertarget{method-KLDivergence-get_kl_result}{}}}
\subsection{Method \code{get_kl_result()}}{
Returns the current KLD result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KLDivergence$get_kl_result()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The current KLD value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KLDivergence-is_drift_detected"></a>}}
\if{latex}{\out{\hypertarget{method-KLDivergence-is_drift_detected}{}}}
\subsection{Method \code{is_drift_detected()}}{
Checks if drift has been detected.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KLDivergence$is_drift_detected()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if drift is detected, otherwise FALSE.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KLDivergence-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KLDivergence-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KLDivergence$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
