% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_waterdata_field_measurements.R
\name{read_waterdata_field_measurements}
\alias{read_waterdata_field_measurements}
\title{Get USGS Field Measurement Water Data}
\usage{
read_waterdata_field_measurements(
  monitoring_location_id = NA_character_,
  parameter_code = NA_character_,
  observing_procedure_code = NA_character_,
  properties = NA_character_,
  field_visit_id = NA_character_,
  approval_status = NA_character_,
  unit_of_measure = NA_character_,
  qualifier = NA_character_,
  value = NA,
  last_modified = NA_character_,
  observing_procedure = NA_character_,
  vertical_datum = NA_character_,
  measuring_agency = NA_character_,
  skipGeometry = NA,
  time = NA_character_,
  bbox = NA,
  limit = NA,
  convertType = TRUE,
  no_paging = FALSE
)
}
\arguments{
\item{monitoring_location_id}{A unique identifier representing a single monitoring location. This corresponds to the \code{id} field in the \code{monitoring-locations} endpoint. Monitoring location IDs are created by combining the agency code of the agency responsible for the monitoring location (e.g. USGS) with the ID number of the monitoring location (e.g. 02238500), separated by a hyphen (e.g. USGS-02238500).

Multiple monitoring_location_ids can be requested as a character vector.}

\item{parameter_code}{Parameter codes are 5-digit codes used to identify the constituent measured and the units of measure. A complete list of parameter codes and associated groupings can be found at \url{https://api.waterdata.usgs.gov/ogcapi/v0/collections/parameter-codes/items}.

Multiple parameter_codes can be requested as a character vector.}

\item{observing_procedure_code}{A short code corresponding to the observing procedure for the field measurement.}

\item{properties}{A vector of requested columns to be returned from the query.
Available options are:
geometry, field_measurement_id, field_visit_id, parameter_code, monitoring_location_id, observing_procedure_code, observing_procedure, value, unit_of_measure, time, qualifier, vertical_datum, approval_status, measuring_agency, last_modified.
The default (\code{NA}) will return all columns of the data.}

\item{field_visit_id}{A universally unique identifier (UUID) for the field visit. Multiple measurements may be made during a single field visit.}

\item{approval_status}{Some of the data that you have obtained from this U.S. Geological Survey database may not have received Director's approval.  Any such data values are qualified as provisional and are subject to revision.  Provisional data are released on the condition that neither the USGS nor the United States Government may be held liable for any damages resulting from its use. This field reflects the approval status of each record, and is either "Approved", meaining processing review has been completed and the data is approved for publication, or "Provisional" and subject to revision. For more information about provisional data, go to \url{https://waterdata.usgs.gov/provisional-data-statement/}.}

\item{unit_of_measure}{A human-readable description of the units of measurement associated with an observation.}

\item{qualifier}{This field indicates any qualifiers associated with an observation, for instance if a sensor may have been impacted by ice or if values were estimated.}

\item{value}{The value of the observation. Values are transmitted as strings in the JSON response format in order to preserve precision.}

\item{last_modified}{The last time a record was refreshed in our database. This may happen due to regular operational processes and does not necessarily indicate anything about the measurement has changed.
You can query this field using date-times or intervals, adhering to RFC 3339, or using ISO 8601 duration objects. Intervals may be bounded or half-bounded (double-dots at start or end).
Examples:
\itemize{
\item A date-time: "2018-02-12T23:20:50Z"
\item A bounded interval: "2018-02-12T00:00:00Z/2018-03-18T12:31:12Z"
\item Half-bounded intervals: "2018-02-12T00:00:00Z/.." or "../2018-03-18T12:31:12Z"
\item Duration objects: "P1M" for data from the past month or "PT36H" for the last 36 hours
}

Only features that have a \code{last_modified} that intersects the value of datetime are selected.}

\item{observing_procedure}{Water measurement or water-quality observing procedure descriptions.}

\item{vertical_datum}{The datum used to determine altitude and vertical position at the monitoring location. A list of codes is available at \url{https://api.waterdata.usgs.gov/ogcapi/v0/collections/altitude-datums/items}.}

\item{measuring_agency}{The agency performing the measurement.}

\item{skipGeometry}{This option can be used to skip response geometries for
each feature. The returning object will be a data frame with no spatial
information.}

\item{time}{The date an observation represents. You can query this field using date-times or intervals, adhering to RFC 3339, or using ISO 8601 duration objects. Intervals may be bounded or half-bounded (double-dots at start or end).
Examples:
\itemize{
\item A date-time: "2018-02-12T23:20:50Z"
\item A bounded interval: "2018-02-12T00:00:00Z/2018-03-18T12:31:12Z"
\item Half-bounded intervals: "2018-02-12T00:00:00Z/.." or "../2018-03-18T12:31:12Z"
\item Duration objects: "P1M" for data from the past month or "PT36H" for the last 36 hours
}

Only features that have a \code{time} that intersects the value of datetime are selected. If a feature has multiple temporal properties, it is the decision of the server whether only a single temporal property is used to determine the extent or all relevant temporal properties.

You can also use a vector of length 2: the first value being the starting date,
the second value being the ending date. NA's within the vector indicate a
half-bound date. For example, c("2024-01-01", NA) will return all data starting
at 2024-01-01.}

\item{bbox}{Only features that have a geometry that intersects the bounding
box are selected.The bounding box is provided as four or six numbers, depending
on whether the coordinate reference system includes a vertical axis (height or
depth). Coordinates are assumed to be in crs 4326. The expected format is a numeric
vector structured: c(xmin,ymin,xmax,ymax). Another way to think of it is c(Western-most longitude,
Southern-most latitude, Eastern-most longitude, Northern-most longitude).}

\item{limit}{The optional limit parameter is used to control the subset of the
selected features that should be returned in each page. The maximum allowable
limit is 50000. It may be beneficial to set this number lower if your internet
connection is spotty. The default (\code{NA}) will set the limit to the maximum
allowable limit for the service.}

\item{convertType}{logical, defaults to \code{TRUE}. If \code{TRUE}, the function
will convert the data to dates and qualifier to string vector.}

\item{no_paging}{logical, defaults to \code{FALSE}. If \code{TRUE}, the data will
be requested from a native csv format. This can be dangerous because the
data will cut off at 50,000 rows without indication that more data
is available. Use \code{TRUE} with caution.}
}
\description{
Field measurements are physically measured values collected during a visit to the monitoring location. Field measurements consist of measurements of gage height and discharge, and readings of groundwater levels, and are primarily used as calibration readings for the automated sensors collecting continuous data. They are collected at a low frequency, and delivery of the data in WDFN may be delayed due to data processing time.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) withAutoprint(\{ # examplesIf}

\donttest{
site <- "USGS-02238500"
field_data_sf <- read_waterdata_field_measurements(monitoring_location_id = site)

groundwater <- read_waterdata_field_measurements(monitoring_location_id = "USGS-375907091432201")

gwl_data <- read_waterdata_field_measurements(monitoring_location_id = "USGS-375907091432201",
                           parameter_code = "72019",
                           skipGeometry = TRUE)
                        
gwl_data_period <- read_waterdata_field_measurements(
                                  monitoring_location_id = "USGS-375907091432201",
                                  parameter_code = "72019",
                                  time = "P20Y")

multi_site <- read_waterdata_field_measurements(
                              monitoring_location_id =  c("USGS-451605097071701",
                                                          "USGS-263819081585801"),
                              parameter_code = c("62611", "72019"))
                              
old_df <- read_waterdata_field_measurements(monitoring_location_id = "USGS-425957088141001", 
                                              time = c("1980-01-01", NA))
                                              
surface_water <- read_waterdata_field_measurements(
                         monitoring_location_id = c("USGS-07069000",
                                                    "USGS-07064000",
                                                    "USGS-07068000"),
                         time = "2024-07-01T00:00:00Z/..",
                         parameter_code = "00060")


}
\dontshow{\}) # examplesIf}
}
