% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readNGWMNdata.R
\name{readNGWMNsites}
\alias{readNGWMNsites}
\title{Retrieve site data from the National Ground Water Monitoring Network.}
\usage{
readNGWMNsites(siteNumbers)
}
\arguments{
\item{siteNumbers}{character Vector of feature IDs formatted with agency code and site number
separated by a period or semicolon, e.g. \code{USGS.404159100494601}.}
}
\value{
A data frame the following columns:
#' \tabular{lll}{
Name \tab Type \tab Description \cr
site \tab char \tab Site FID \cr
description \tab char \tab Site description \cr
dec_lat_va, dec_lon_va \tab numeric \tab Site latitude and longitude \cr
}
}
\description{
Retrieve site data from the National Ground Water Monitoring Network.
}
\examples{
\dontshow{if (is_dataRetrieval_user()) withAutoprint(\{ # examplesIf}
\donttest{
# one site
site <- "USGS.430427089284901"
#oneSite <- readNGWMNsites(siteNumbers = site)

# non-USGS site
site <- "MBMG.103306"
#siteInfo <- readNGWMNsites(siteNumbers = site)
}
\dontshow{\}) # examplesIf}
}
