% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_col_as.R
\name{set_col_as_factor}
\alias{set_col_as_factor}
\title{Set columns as factor}
\usage{
set_col_as_factor(data_set, cols = "auto", n_levels = 53, verbose = TRUE)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{cols}{List of column(s) name(s) of data_set to transform into factor. To transform all columns
set it to "auto", (characters, default to auto).}

\item{n_levels}{Max number of levels for factor (integer, default to 53)
set it to -1 to disable control.}

\item{verbose}{Should the function log (logical, default to TRUE)}
}
\value{
\code{data_set}(as a \code{\link[data.table]{data.table}}), with specified columns set as factor or logical.
}
\description{
Set columns as factor and control number of unique element, to avoid having too large factors.
}
\details{
Control number of levels will help you to distinguish true categorical columns from just characters
that should be handled in another way.
}
\examples{
# Load messy_adult
data(tiny_messy_adult)

# we wil change education
tiny_messy_adult <- set_col_as_factor(tiny_messy_adult, cols = "education")

sapply(tiny_messy_adult[, .(education)], class)
# education is now a factor
}
