% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_tune.R
\name{reg_tune}
\alias{reg_tune}
\title{Regression tuning (k-fold CV)}
\usage{
reg_tune(base_model, folds = 10, ranges = NULL)
}
\arguments{
\item{base_model}{base model for tuning}

\item{folds}{number of folds for cross-validation}

\item{ranges}{a list of hyperparameter ranges to explore}
}
\value{
returns a \code{reg_tune} object.
}
\description{
Tune hyperparameters of a base regressor via k‑fold cross‑validation minimizing an error metric (MSE).
}
\examples{
# preparing dataset for random sampling
data(Boston)
sr <- sample_random()
sr <- train_test(sr, Boston)
train <- sr$train
test <- sr$test

# hyper parameter setup
tune <- reg_tune(reg_mlp("medv"), ranges = list(size=c(3), decay=c(0.1,0.5)))

# hyper parameter optimization
model <- fit(tune, train, ranges)

test_prediction <- predict(model, test)
test_predictand <- test[,"medv"]
test_eval <- evaluate(model, test_predictand, test_prediction)
test_eval$metrics
}
\references{
Kohavi, R. (1995). A Study of Cross-Validation and Bootstrap for Accuracy Estimation and Model Selection.
}
