% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cmfactorfit.R
\name{plot.cmfactorfit}
\alias{plot.cmfactorfit}
\title{Plot cmfactorfit objects}
\usage{
\method{plot}{cmfactorfit}(x, fit = "both", colors = NULL, legend = TRUE, ...)
}
\arguments{
\item{x}{a cmfactorfit object}

\item{fit}{a character (either "null", "alt", or "both") that dictates what fits will be plotted}

\item{colors}{vector of colors (one component for each individual fit being plotted) for the hazard estimates}

\item{legend}{boolean parameter dictating whether or not a legend will be added to the plot}

\item{...}{additional parameters to pass to the \code{\link{plot.cmfit}} function. Perhaps most usefully: lowering the default nreps (e.g. to 1000) makes plotting much faster.}
}
\value{
a plot comparing the hazard estimates from the null model with the individual estimates from each factor level
}
\description{
Plot cmfactorfit objects
}
\examples{
# fit factorial model
data(seasonalsex)
seasonalsex.factorfit <- factorfit_cyclomort(event ~ sex, data = seasonalsex, n.seasons = 1)

# summary
summary(seasonalsex.factorfit, coefs = TRUE)
\donttest{plot(seasonalsex.factorfit)}
}
