% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cry_generics_S3.R
\name{calculate_cell_volume}
\alias{calculate_cell_volume}
\title{S3 generic to compute cell volume}
\usage{
calculate_cell_volume(x, ...)
}
\arguments{
\item{x}{An object used to select a method. Either an object of class
unit_cell or an object of class rec_unit_cell.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
V A real number. The volume (in \eqn{angstroms^3} or
          \eqn{angstroms^{-3}}) of the input unit cell or reciprocal
          unit cell.
}
\description{
The volume of a unit cell and a reciprocal unit cell can be calculated starting
from specific objects, files, etc.
}
\examples{
# Calculate the volume of a unit cell
uc <- unit_cell(20)
V <- calculate_cell_volume(uc)

# Calculate the volume of the corresponding reciprocal cell
ruc <- create_rec_unit_cell(uc)
Vrec <- calculate_cell_volume(ruc)
V*Vrec  # Should be 1!

}
