% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_fit_robust.R
\name{cross_fit_robust}
\alias{cross_fit_robust}
\title{Cross fit robust linear models}
\usage{
cross_fit_robust(
  data,
  formulas,
  cols = NULL,
  weights = NULL,
  clusters = NULL,
  fn_args = list(),
  tidy = tidy_glance,
  tidy_args = list(),
  errors = c("stop", "warn")
)
}
\arguments{
\item{data}{A data frame}

\item{formulas}{A list of formulas to apply to each subset of the data.
If named, these names will be used in the \code{model} column of the output.
Otherwise, the formulas will be converted to strings in the \code{model} column.}

\item{cols}{Columns to subset the data.
Can be any expression supported by
<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>.
If \code{\link{NULL}}, the data is not subset into columns.
Defaults to \code{NULL}.}

\item{weights}{A list of columns passed to \code{weights} in \code{fn}.
If one of the elements is \code{\link{NULL}} or \code{\link{NA}}, that model will not
be weighted.
Defaults to \code{NULL}.}

\item{clusters}{A list of columns passed to \code{clusters}.
If one of the elements is \code{\link{NULL}} or \code{\link{NA}}, that model will not
be clustered.
Defaults to \code{NULL}.}

\item{fn_args}{A list of additional arguments to \code{\link[estimatr:lm_robust]{estimatr::lm_robust()}}.}

\item{tidy}{A logical or function to use to tidy model output into
data.frame columns.
If \code{TRUE}, uses the default tidying function: \code{\link[=tidy_glance]{tidy_glance()}}.
If \code{FALSE}, \code{NA}, or \code{NULL}, the untidied model output will be returned in
a list column named \code{fit}.
An alternative function can be specified with an unquoted function name or
a \link[purrr:map]{purrr}-style lambda function with one argument (see usage
with \link[broom:tidy.lm]{broom::tidy(conf.int = TRUE)} in examples).
Defaults to \link{tidy_glance}.}

\item{tidy_args}{A list of additional arguments to the \code{tidy} function}

\item{errors}{If \code{"stop"}, the default, the function will stop and return an
error if any subset produces an error.
If \code{"warn"}, the function will produce a warning for subsets that produce
an error and return results for all subsets that do not.}
}
\value{
A tibble with a column for the model formula,
columns for subsets,
columns for the weights and clusters (if applicable),
and columns of tidy model output or a list column of models
(if \code{tidy = FALSE})
}
\description{
Cross fit robust linear models
}
\examples{
\dontshow{if (getRversion() >= "3.5") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cross_fit_robust(mtcars, mpg ~ wt, cyl, clusters = list(NULL, am))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=cross_fit]{cross_fit()}} to use any modeling function.
}
