% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{fraudulent_df}
\alias{fraudulent_df}
\title{Fraudulent Automobile Insurance Claims}
\format{
A data frame with 42 observations and 12 variables:
\describe{
  \item{r1}{Numeric score or rating 1 (numeric).}
  \item{r2}{Numeric score or rating 2 (numeric).}
  \item{AC1}{Indicator for a specific automobile claim condition (factor with 2 levels).}
  \item{AC9}{Indicator for a second specific automobile claim condition (factor with 2 levels).}
  \item{AC16}{Indicator for a third specific automobile claim condition (factor with 2 levels).}
  \item{CL7}{Claim-level indicator for condition 7 (factor with 2 levels).}
  \item{CL11}{Claim-level indicator for condition 11 (factor with 2 levels).}
  \item{IJ2}{Insurance adjuster’s information indicator for condition 2 (factor with 2 levels).}
  \item{IJ3}{Insurance adjuster’s information indicator for condition 3 (factor with 2 levels).}
  \item{IJ4}{Insurance adjuster’s information indicator for condition 4 (factor with 2 levels).}
  \item{IJ6}{Insurance adjuster’s information indicator for condition 6 (factor with 2 levels).}
  \item{IJ12}{Insurance adjuster’s information indicator for condition 12 (factor with 2 levels).}
}
}
\source{
Fraudulent automobile insurance claims data from Massachusetts, 1989.
}
\usage{
data(fraudulent_df)
}
\description{
This dataset contains information on 127 automobile insurance claims arising from accidents in Massachusetts, USA, in 1989.
Each claim was classified as either fraudulent or legitimate by consensus among four independent claims adjusters who thoroughly examined each case file.
}
\details{
The dataset name has been changed to 'fraudulent_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the crimedatasets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a traditional data frame in R. The original content has not been modified in any way.
}
