% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{crimestatewide_tbl_df}
\alias{crimestatewide_tbl_df}
\title{Annual Crime Dataset of US Counties}
\format{
A tibble with 51 observations and 9 variables:
\describe{
  \item{State}{State name (character).}
  \item{violent crime rate}{Violent crime rate per 100,000 people (numeric).}
  \item{murder rate}{Murder rate per 100,000 people (numeric).}
  \item{poverty}{Poverty rate as a percentage (numeric).}
  \item{high school}{Percentage of high school graduates (numeric).}
  \item{college}{Percentage of college graduates (numeric).}
  \item{single parent}{Percentage of single-parent households (numeric).}
  \item{unemployed}{Unemployment rate as a percentage (numeric).}
  \item{metropolitan}{Percentage of the population living in metropolitan areas (numeric).}
}
}
\source{
Annual crime data of US counties.
}
\usage{
data(crimestatewide_tbl_df)
}
\description{
This dataset contains annual crime-related statistics for US counties, including violent crime rates,
murder rates, and socio-economic indicators such as poverty, education, and unemployment. It provides
a comprehensive overview of crime and its potential correlates across the United States.
}
\details{
The dataset name has been changed to 'crimestatewide_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
crimedatasets package and assists users in identifying its specific characteristics. The suffix
'tbl_df' indicates that the dataset is stored as a tibble, a modern and more readable alternative
to traditional data frames in R. The original content has not been modified in any way.
}
