% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dep.R
\name{get_dep}
\alias{get_dep}
\title{Multiple types of dependencies}
\usage{
get_dep(name, type, reverse = FALSE)
}
\arguments{
\item{name}{String, name of the package}

\item{type}{A character vector that contains one or more of the following dependency words: "Depends", "Imports", "LinkingTo", "Suggests", "Enhances", up to letter case and space replaced by underscore. Alternatively, if 'type = "all"', all five dependencies will be obtained; if 'type = "strong"', "Depends", "Imports" & "LinkingTo" will be obtained.}

\item{reverse}{Boolean, whether forward (FALSE, default) or reverse (TRUE) dependencies are requested.}
}
\value{
A data frame of dependencies
}
\description{
\code{get_dep} returns a data frame of multiple types of dependencies of a package
}
\examples{
get_dep("dplyr", c("Imports", "Depends"))
get_dep("MASS", c("Suggests", "Depends", "Imports"), TRUE)
}
\seealso{
\code{\link{get_dep_all_packages}} for the dependencies of all CRAN packages, and \code{\link{get_graph_all_packages}} for obtaining directly a network of dependencies as an igraph object
}
