% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sinkhorn_algorithm.R
\name{sinkhorn_algorithm}
\alias{sinkhorn_algorithm}
\title{Sinkhorn Algorithm for Matrix Scaling}
\usage{
sinkhorn_algorithm(initial_table, obj, max_iter = 500, tolerance = 1e-05)
}
\arguments{
\item{initial_table}{A matrix to be adjusted using the Sinkhorn algorithm.}

\item{obj}{An objective function to evaluate the matrix (e.g., entropy, mutual information).}

\item{max_iter}{The maximum number of iterations for the algorithm (default is 500).}

\item{tolerance}{The convergence tolerance. If the change in the objective function is smaller than this,
the algorithm stops (default is 1e-5).}
}
\value{
A list containing:
\itemize{
\item \code{updated_table}: The matrix after Sinkhorn scaling.
\item \code{new_mut}: The objective function value for the scaled matrix.
\item \code{iter}: The number of iterations performed.
\item \code{mutual_info_history}: A data frame with the history of objective function values during each iteration.
}
}
\description{
This function applies the Sinkhorn-Knopp algorithm to adjust the row and column sums of a matrix
to match the target sums. The algorithm iteratively scales the rows and columns by updating
scaling factors (alpha and beta) until convergence or the maximum number of iterations is reached.
}
\examples{
initial_table <- matrix(c(5, 3, 4, 2), nrow = 2, ncol = 2)
obj <- entropy_pair  # Example entropy function
result <- sinkhorn_algorithm(initial_table, obj)

}
