% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_target_entropy.R
\name{get_target_entropy}
\alias{get_target_entropy}
\title{Get Target Entropy}
\usage{
get_target_entropy(x, y, target_entropy, max_n = 10000, epsilon = 0.001)
}
\arguments{
\item{x}{A vector of categorical values representing variable x.}

\item{y}{A vector of categorical values representing variable y.}

\item{target_entropy}{The target entropy value to be reached.}

\item{max_n}{Maximum number of iterations for the optimization process (default is 10,000).}

\item{epsilon}{The tolerance value for determining if the target entropy has been reached (default is 0.001).}
}
\value{
A list containing:
\itemize{
\item final_df: A dataframe with the adjusted contingency table.
\item final_table: The final contingency table after adjustments.
\item history: The history of the optimization process.
\item max_mut: The maximum mutual information found.
\item min_mut: The minimum mutual information found.
}
}
\description{
This function adjusts the mutual information between two categorical variables (x and y)
by modifying their contingency table using simulated annealing to reach a target entropy.
The function first calculates the range of possible entropy values (min and max) and checks if the target entropy
lies within that range. If so, it adjusts the mutual information to reach the target entropy, either by increasing or
decreasing it, depending on the initial entropy value.
}
\examples{
set.seed(33)
df <- data.frame(
  x = sample(paste("Categ", 1:4), 10000, replace = TRUE),
  y = sample(paste("Categ", 10:4), 10000, replace = TRUE)
)
target_entropy <- 1  # Set your target entropy here
\donttest{res <- get_target_entropy(df$x, df$y, target_entropy)}


}
