% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrCombo.R
\docType{class}
\name{CorrCombo}
\alias{CorrCombo}
\alias{CorrCombo-class}
\alias{show,CorrCombo-method}
\title{CorrCombo S4 class}
\usage{
\S4method{show}{CorrCombo}(object)
}
\arguments{
\item{object}{A \code{CorrCombo} object to be printed.}
}
\description{
Holds the result of \code{\link{corrSelect}} or \code{\link{MatSelect}}: a list of valid variable combinations
and their correlation statistics.

This class stores all subsets of variables that meet the specified correlation constraint,
along with metadata such as the algorithm used, correlation method(s), variables forced into every subset,
and summary statistics for each combination.
}
\section{Slots}{

\describe{
\item{\code{subset_list}}{A list of character vectors. Each vector is a valid subset (variable names).}

\item{\code{avg_corr}}{A numeric vector. Average absolute correlation within each subset.}

\item{\code{min_corr}}{A numeric vector. Minimum pairwise absolute correlation in each subset.}

\item{\code{max_corr}}{A numeric vector. Maximum pairwise absolute correlation within each subset.}

\item{\code{names}}{Character vector of all variable names used for decoding.}

\item{\code{threshold}}{Numeric scalar. The correlation threshold used during selection.}

\item{\code{forced_in}}{Character vector. Variable names that were forced into each subset.}

\item{\code{search_type}}{Character string. One of \code{"els"} or \code{"bron-kerbosch"}.}

\item{\code{cor_method}}{Character string. Either a single method (e.g. "pearson") or "mixed" if multiple methods used.}

\item{\code{n_rows_used}}{Integer. Number of rows used for computing the correlation matrix (after removing missing values).}
}}

\examples{
show(new("CorrCombo",
  subset_list = list(c("A", "B"), c("A", "C")),
  avg_corr = c(0.2, 0.3),
  min_corr = c(0.1, 0.2),
  max_corr = c(0.3, 0.4),
  names = c("A", "B", "C"),
  threshold = 0.5,
  forced_in = character(),
  search_type = "els",
  cor_method = "mixed",
  n_rows_used = as.integer(5)
))

}
\seealso{
\code{\link{corrSelect}}, \code{\link{MatSelect}}, \code{\link{corrSubset}}
}
