% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kfold_ttest.R
\name{kfold_ttest}
\alias{kfold_ttest}
\title{Compute correlated t-statistic and p-value for k-fold cross-validated results}
\usage{
kfold_ttest(x, y, n, k, tailed = c("two", "one"), greater = NULL)
}
\arguments{
\item{x}{\code{numeric} vector of values for model A}

\item{y}{\code{numeric} vector of values for model B}

\item{n}{\code{integer} denoting total sample size}

\item{k}{\code{integer} denoting number of folds used in k-fold}

\item{tailed}{\code{character} denoting whether to perform a two-tailed or one-tailed test. Can be one of \code{"two"} or \code{"one"}. Defaults to \code{"two"}}

\item{greater}{\code{character} specifying whether \code{"x"} or \code{"y"} is greater for the one-tailed test if \code{tailed = "one"}. Defaults to \code{NULL}}
}
\value{
\code{data.frame} containing the test statistic and p-value
}
\description{
Compute correlated t-statistic and p-value for k-fold cross-validated results
}
\examples{
x <- rnorm(100, mean = 95, sd = 0.5)
y <- rnorm(100, mean = 90, sd = 1)
kfold_ttest(x = x, y = y, n = 100, k = 5, tailed = "two")

}
\references{
Nadeau, C., and Bengio, Y. Inference for the Generalization Error. Machine Learning 52, (2003).

Corani, G., Benavoli, A., Demsar, J., Mangili, F., and Zaffalon, M. Statistical comparison of classifiers through Bayesian hierarchical modelling. Machine Learning, 106, (2017).
}
\author{
Trent Henderson
}
