% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/async.R
\name{async}
\alias{async}
\alias{await}
\title{Make an async function}
\usage{
async(fn)

await(x)
}
\arguments{
\item{fn}{An anonymous function within which \code{await()} calls are
allowed.}

\item{x}{An awaitable value, i.e. a \link[promises:promise]{promise}.}
}
\value{
A function that returns a \code{\link[promises:promise]{promises::promise()}} invisibly.
}
\description{
\code{async()} functions are building blocks for cooperative
concurrency.
\itemize{
\item They are \emph{concurrent} because they are jointly managed by a
scheduler in charge of running them.
\item They are \emph{cooperative} because they decide on their own when they
can no longer make quick progress and need to \strong{await} some
result. This is done with the \code{await()} keyword which suspends
the async function and gives control back to the scheduler. The
scheduler waits until the next async operation is ready to make
progress.
}

The async framework used by \code{async()} functions is implemented in
the \href{https://github.com/r-lib/later/}{later} and
\href{https://rstudio.github.io/promises/}{promises} packages:
\itemize{
\item You can chain async functions created with coro to promises.
\item You can await promises. You can also await futures created with
the \href{https://github.com/HenrikBengtsson/future}{future} package
because they are coercible to promises.
}
}
\examples{
# This async function counts down from `n`, sleeping for 2 seconds
# at each iteration:
async_count_down <- async(function(n) {
  while (n > 0) {
    cat("Down", n, "\n")
    await(async_sleep(2))
    n <- n - 1
  }
})

# This async function counts up until `stop`, sleeping for 0.5
# seconds at each iteration:
async_count_up <- async(function(stop) {
  n <- 1
  while (n <= stop) {
    cat("Up", n, "\n")
    await(async_sleep(0.5))
    n <- n + 1
  }
})

# You can run these functions concurrently using `promise_all()`
if (interactive()) {
  promises::promise_all(async_count_down(5), async_count_up(5))
}
}
\seealso{
\code{\link[=async_generator]{async_generator()}} and \code{\link[=await_each]{await_each()}};
\code{\link[=coro_debug]{coro_debug()}} for step-debugging.
}
