% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_scientific_name.R
\name{set_scientific_name}
\alias{set_scientific_name}
\title{Set, create or modify columns with scientific name & authorship information}
\usage{
set_scientific_name(
  .df,
  scientificName = NULL,
  scientificNameAuthorship = NULL,
  taxonRank = NULL,
  .keep = "unused"
)
}
\arguments{
\item{.df}{A \code{data.frame} or \code{tibble} that the column should be appended to.}

\item{scientificName}{The full scientific name in the lower level taxonomic
rank that can be determined.}

\item{scientificNameAuthorship}{The authorship information for \code{scientificName}.}

\item{taxonRank}{The taxonomic rank of \code{scientificName}.}

\item{.keep}{Control which columns from .data are retained in the output.
Note that unlike \code{\link[dplyr:mutate]{dplyr::mutate()}}, which defaults to \code{"all"} this defaults to
\code{"unused"}; i.e. only keeps Darwin Core columns, and not those columns used to
generate them.}
}
\value{
A tibble with the requested columns added/reformatted.
}
\description{
Format the field \code{scientificName}, the lowest identified taxonomic name of an
occurrence, along with the rank and authorship of the provided name to a
\code{tibble} using Darwin Core Standard.
}
\details{
In practice this function is used no differently from \code{mutate()}, but gives
users some informative errors, and serves as a useful lookup for accepted
column names in the Darwin Core Standard.

Examples of \code{scientificName} values (we specify the rank in parentheses, but
users should not include this information):
\itemize{
\item \code{Coleoptera} (order)
\item \code{Vespertilionidae} (family)
\item \code{Manis} (genus)
\item \verb{Ctenomys sociabilis} (genus + specificEpithet)
\item \verb{Ambystoma tigrinum diaboli} (genus + specificEpithet + infraspecificEpithet)
}

Examples of \code{scientificNameAuthorship}:
\itemize{
\item \verb{(Györfi, 1952)}
\item \verb{R. A. Graham}
\item \verb{(Martinovský) Tzvelev}
}

Examples of \code{taxonRank}:
\itemize{
\item \code{order}
\item \code{genus}
\item \code{subspecies}
\item \code{infraspecies}
}
}
\examples{
df <- tibble::tibble(
  name = c("Crinia Signifera", "Crinia Signifera", "Litoria peronii"),
  latitude = c(-35.27, -35.24, -35.83),
  longitude = c(149.33, 149.34, 149.34),
  eventDate = c("2010-10-14", "2010-10-14", "2010-10-14")
  )

# Reformat columns to Darwin Core Standard terms
df |>
  set_scientific_name(
    scientificName = name
    )

}
\seealso{
\code{\link[=set_taxonomy]{set_taxonomy()}} for taxonomic name information.
}
