% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/country_codes.R
\docType{data}
\name{country_codes}
\alias{country_codes}
\title{Dataset of supported Country Codes}
\format{
A \code{tibble} containing valid country codes (249 rows x 3 columns).
Column descriptions are as follows:
\describe{
\item{name}{ISO 3166-1 alpha-2 code, pointing to its ISO 3166-2 article.}
\item{code}{English short name officially used by the ISO 3166 Maintenance Agency (ISO 3166/MA).}
\item{year}{Year when alpha-2 code was first officially assigned.}
}
}
\source{
\href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{Wikipedia}.
}
\usage{
country_codes
}
\description{
A \code{tibble} of ISO 3166-1 alpha-2 codes for countries, which are
the accepted standard for supplying \code{countryCode} in Darwin Core Standard.
}
\seealso{
\code{\link[=set_locality]{set_locality()}} for assigning \code{countryCode} within a tibble;
\code{\link[=countryCode_values]{countryCode_values()}} to return valid codes as a vector.
}
\keyword{datasets}
