% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{connector_databricks_table}
\alias{connector_databricks_table}
\title{Create \code{ConnectorDatabricksTable} connector}
\usage{
connector_databricks_table(http_path, catalog, schema, extra_class = NULL)
}
\arguments{
\item{http_path}{\link{character} The path to the Databricks cluster or SQL
warehouse you want to connect to}

\item{catalog}{\link{character} The catalog to use}

\item{schema}{\link{character} The schema to use}

\item{extra_class}{\link{character} Extra class to assign to the new connector}
}
\value{
A new \link{ConnectorDatabricksTable} object
}
\description{
Initializes the connector for table type of storage.
See \link{ConnectorDatabricksTable} for details.
}
\details{
The \code{extra_class} parameter allows you to create a subclass of the
\code{ConnectorDatabricksTable} object. This can be useful if you want to create
a custom connection object for easier dispatch of new s3 methods, while still
inheriting the methods from the \code{ConnectorDatabricksTable} object.
}
\examples{
\dontrun{
# Establish connection to your cluster

con_databricks <- connector_databricks_table(
  http_path = "path-to-cluster",
  catalog = "my_catalog",
  schema = "my_schema"
)

# List tables in my_schema

con_databricks$list_content()

# Read and write tables

con_databricks$write(mtcars, "my_mtcars_table")

con_databricks$read("my_mtcars_table")

# Use dplyr::tbl

con_databricks$tbl("my_mtcars_table")

# Remove table

con_databricks$remove("my_mtcars_table")

# Disconnect

con_databricks$disconnect()
}
}
