% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{con_concur}
\alias{con_concur}
\title{View concurrence of two factors in a dataframe using a matrix plot.}
\usage{
con_concur(
  data,
  formula,
  dropNA = TRUE,
  xlab = "",
  ylab = "",
  cex.x = 0.7,
  cex.y = 0.7,
  ...
)
}
\arguments{
\item{data}{A dataframe}

\item{formula}{A formula with multiple factor names in the dataframe,
like \code{y ~ f1 / f2}.}

\item{dropNA}{If TRUE, observed data that are \code{NA} will be dropped.}

\item{xlab}{Label for x axis}

\item{ylab}{Label for y axis}

\item{cex.x}{Scale factor for x axis tick labels.  Default 0.7.}

\item{cex.y}{Scale factor for y axis tick labels  Default 0.7.}

\item{...}{Other parameters passed to the levelplot() function.}
}
\value{
A lattice graphics object
}
\description{
Draws a concurrence plot of 2 factors in a dataframe.
For example, in a multi-environment yield trial (testing multiple crop
varieties in multple environments) it is interesting to examine the
balance of the testing pattern.
For each pair of environments, how many genotypes are tested
in both environments? The concurrence plot shows the amount of
connectedness (number of varieties) of the environments with each other.

By default, missing values in the response are deleted.

Replicated combinations of the two factors are ignored.
(This could be changed if someone has a need.)
}
\examples{
require(lattice)
bar = transform(lattice::barley, env=factor(paste(site,year)))
set.seed(123)
bar <- bar[sample(1:nrow(bar), 70, replace=TRUE),]
con_concur(bar, yield ~ variety / env, cex.x=0.75, cex.y=.3)

}
\references{
None
}
\author{
Kevin Wright
}
