% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver_coordinate.R
\name{coordinate_ascent}
\alias{coordinate_ascent}
\title{Coordinate Ascent Solver}
\usage{
coordinate_ascent(
  max_cycles = 50L,
  tol = 1e-08,
  line_search = TRUE,
  cycle_order = c("sequential", "random"),
  verbose = FALSE
)
}
\arguments{
\item{max_cycles}{Maximum number of full cycles through all parameters}

\item{tol}{Convergence tolerance on log-likelihood change}

\item{line_search}{Use line search for each coordinate (slower but more robust)}

\item{cycle_order}{Order of cycling: "sequential" (1,2,...,p) or "random"}

\item{verbose}{Logical; if TRUE and the \pkg{cli} package is installed,
display progress during optimization. Default is FALSE.}
}
\value{
A solver function with signature (problem, theta0, trace) -> mle_result
}
\description{
Creates a solver that optimizes one parameter at a time while holding
others fixed. This is useful when parameters have different scales or
when the likelihood decomposes nicely along coordinate directions.
}
\details{
Each cycle consists of optimizing each coordinate in turn using a simple
golden section search. The algorithm converges when the log-likelihood
improvement in a full cycle is less than \code{tol}.

Coordinate ascent can be effective when:
\itemize{
  \item Parameters are on very different scales
  \item The likelihood has axis-aligned ridges
  \item Computing the full gradient is expensive
}

However, it may converge slowly for problems with strong parameter correlations.
}
\examples{
# Basic coordinate ascent
solver <- coordinate_ascent()

# With more cycles for difficult problems
solver <- coordinate_ascent(max_cycles = 100)

# Random cycling to avoid systematic bias
solver <- coordinate_ascent(cycle_order = "random")

}
\seealso{
\code{\link{gradient_ascent}} for gradient-based optimization,
  \code{\link{nelder_mead}} for another derivative-free method
}
